{ P_57_1 -     }
(*   ABCNet *)

function Assigned(p : pointer): boolean;  {  ABCNet }
begin
  Assigned:= p<>nil
end;

type
      PNode = ^TNode;     {    - }
      PLink = ^TLink;     {      }

      TLink = record      {    }
        mLink : PNode;    {     }
        mNext : PLink;    {       }
      end;

      TNode = record      {      ( ) }
        mName : Char;     {   ( ) }
        mLinks: PLink;    {  - ( ) }
        mNext : PNode;    {       }
      end;

var List : PNode;   {     ( ) }

  {    ( )    }

function GetPtr(aName : char): PNode;
var p : PNode;
begin
  p:= List; {      }
  {     }
  while Assigned(p) do begin
    if p^.mName= aName
      then break             { ! }
      else p:= p^.mNext;     {    }
  end;
  GetPtr:= p;
end;

  {     (),
        List
          }

function MakeNode(aName : Char): PNode;
var  p : PNode;
begin
  New(p);             {   }
  p^.mName:= aName;   {   }
  p^.mLinks:=nil;     {     }
  p^.mNext:= List;    {       }
  List:= p;           {      }
  MakeNode:= p;       {    }
end;

  {  ,    p1   p2 }

function IsLink(p1, p2 : PNode): boolean;
var  p : PLink;
begin
  p:= p1^.mLinks; {        p1 }
  {      p1 }
  while Assigned(p) do begin
    if p^.mLink=p2
      then break          { ! }
      else p:= p^.mNext   {    }
  end;
  IsLink:= Assigned(p);   { TRUE,    }
end;

  {     p1   p2 }

procedure Link(p1, p2 : PNode);
var  p : PLink;
begin
  New(p);                 {  - }
  p^.mLink:= p2;          {  mLink    p2 }
  p^.mNext:= p1^.mLinks;  {       }
  p1^.mLinks:= p;         {      }
end;

  {      .
          ( )
      - (   ) }
    
procedure ReadData(var F: Text);
var C : Char;
    p, q : PNode;
begin
  Reset(F);
  while not Eof(F) do begin
    if not Eoln(F) then begin     {     }
      Read(F, C);                 {    }
      C:=UpCase(C);               {     }
      p:= GetPtr(C);              {      ? }
      if not Assigned(p)
        then p:= MakeNode(C);     {  , -  }
      while not Eoln(F) do begin  {  -    }
        Read(F, C);
        C:= UpCase(C);
        if C in ['A'..'Z'] then begin   {    ... }
          q:= GetPtr(C);                {    }
          if not Assigned(q)
            then q:= MakeNode(C);       {   , -  }
          if not IsLink(p,q) then begin {     ... }
            Link(p, q);                 {   p  q }
            Link(q, p);                 {  q  p }
          end
        end
      end
    end;
    Readln(F);   {      }
  end;
end;

  {    }

procedure ExpoData(var F: Text);
var p : PNode;
    q : PLink;
begin
  Rewrite(F);
  p:= List;   {     () }
  while Assigned(p) do begin
    Write (F, p^.mName);          {   }
    q:= p^.mLinks;                {     }
    while Assigned(q) do begin
      Write(F, ' ', q^.mLink^.mName); {   }
      q:= q^.mNext;                   {   }
    end;
    Writeln(F);      {   }
    p:= p^.mNext;    {   }
  end;
  Close(F);
end;

var    F_In, F_Out : Text;  {     }

begin {   }
  List:= nil;
  Assign(F_In, 'P_57_1.in');
  ReadData(F_In);                 {      }
  Assign(F_Out,'P_57_1.out');
  ExpoData(F_Out);                {     }
end.

